/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.IVWPastable;
import filenet.vw.api.VWArrayHandler;
import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWException;
import filenet.vw.api.VWJoinType;
import filenet.vw.api.VWMLABase;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWRouteDefinition;
import filenet.vw.api.VWRuleSetDefinition;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWSplitType;
import filenet.vw.api.VWStepPaletteDefinition;
import filenet.vw.api.VWValidationContext;
import java.awt.Point;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public abstract class VWMapNode
extends VWMLABase
implements Serializable,
Cloneable,
IVWPastable {
    private static final long serialVersionUID = 7463L;
    protected String name;
    protected int stepId;
    private String description = null;
    private String documentation = null;
    private String authorTool = null;
    private Point location;
    private int splitType = 3;
    private int joinType = 3;
    private int joinStepId = -1;
    private VWMapDefinition myMap;
    private VWStepPaletteDefinition myStepPalette;
    protected VWAttributeInfo attributes = null;
    protected Integer[] outGoingRoutes = null;
    protected VWArrayHandler outGoingRoutesHandler = new VWArrayHandler(5, 5);
    public static final int PRE_RULESETS = 0;
    public static final int UPDATE_RULESETS = 1;
    public static final int POST_RULESETS = 2;
    protected String[][] ruleSets = new String[3][];
    private Object originalNodeGraphicsInfosNode = null;

    public static String _get_FILE_DATE() {
        return "$Date: 2010-06-16 18:58:21 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Kevin Bentley;096657649;kbentley@us.ibm.com (kbentley) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_451_Int/PUI_452_Int/PUI_460_Int/6 $";
    }

    public abstract void validate(VWSession var1, Vector var2) throws VWException;

    protected abstract void validate(VWValidationContext var1) throws VWException;

    public abstract void toXML(StringBuffer var1) throws VWException;

    public abstract void toXPDL(String var1, StringBuffer var2) throws VWException;

    public abstract String toString();

    protected VWMapNode(VWMapDefinition theMap, String theName, int theStepId) throws VWException {
        if (theMap == null) {
            throw new VWException("vw.api.VWStepDefinitionInvalidMap", "theMap is invalid, (null).");
        }
        VWMapNode existingStep = null;
        try {
            existingStep = theMap.getStep(theStepId);
        }
        catch (VWException e) {
            // empty catch block
        }
        if (existingStep != null) {
            throw new VWException("vw.api.VWStepDefinitionStepIdAlreadyExists", "theStepId is invalid, (a step with ID {0} already exists in this workflow definition).", String.valueOf(theStepId));
        }
        this.setMap(theMap);
        this.setStepId(theStepId);
        this.setName(theName);
    }

    protected VWMapNode(VWMapDefinition theMap) {
        this.setMap(theMap);
        this.setStepId(-1);
    }

    protected VWMapNode(VWStepPaletteDefinition theStepPalette) {
        this.myStepPalette = theStepPalette;
        this.setStepId(-1);
    }

    protected VWMapNode(int theStepId) {
        this.setStepId(theStepId);
    }

    public String getAuthoredName() {
        return this.name;
    }

    public String getName() {
        return this.translateStr(this.name);
    }

    public void setName(String theName) throws VWException {
        this.name = theName;
    }

    public String getDescription() {
        return this.translateStr(this.description);
    }

    public void setDescription(String theDescription) {
        this.description = theDescription;
    }

    public void setDocumentation(String theDocumentation) {
        this.documentation = theDocumentation;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void setAuthorTool(String s) {
        this.authorTool = s;
    }

    public String getAuthorTool() {
        return this.authorTool;
    }

    public int getStepId() {
        return this.stepId;
    }

    protected void setStepId(int theStepId) {
        this.stepId = theStepId;
    }

    public Point getLocation() {
        return this.location;
    }

    public void setLocation(Point theLocation) {
        this.location = theLocation;
    }

    public int getSplitType() {
        return this.splitType;
    }

    public void setSplitType(int theSplitType) throws VWException {
        if (!VWSplitType.isValid(theSplitType)) {
            throw new VWException("vw.api.VWStepDefinitionInvalidSplitType", "theSplitType is invalid.");
        }
        this.splitType = theSplitType;
    }

    public int getJoinType() {
        return this.joinType;
    }

    public void setJoinType(int theJoinType) throws VWException {
        if (!VWJoinType.isValid(theJoinType)) {
            throw new VWException("vw.api.VWStepDefinitionInvalidJoinType", "theJoinType is invalid.");
        }
        this.joinType = theJoinType;
    }

    protected void setJoinStepId(int theStepId) {
        this.joinStepId = theStepId;
    }

    protected int getJoinStepId() {
        return this.joinStepId;
    }

    public VWAttributeInfo getAttributeInfo() throws VWException {
        return this.attributes;
    }

    public void setAttributeInfo(VWAttributeInfo theAttributeInfo) throws VWException {
        this.attributes = theAttributeInfo;
    }

    protected Hashtable getAttributes() throws VWException {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.attributes;
    }

    protected void setAttributes(Hashtable theAttributes) throws VWException {
        if (this.attributes == null) {
            this.attributes = new VWAttributeInfo();
        }
        this.attributes.attributes = theAttributes;
    }

    protected String[] getAttributeNames() throws VWException {
        if (this.attributes == null) {
            return null;
        }
        return VWAttributeInfo.getAttributeNames(this.attributes.attributes);
    }

    public void deleteRoute(int theRouteId) throws VWException {
        if (this.getMap() != null) {
            VWRouteDefinition route = this.getMap().getRoute(theRouteId);
            if (route.getSourceStepId() != this.stepId) {
                throw new VWException("vw.api.VWStepDefinitionInvalidRouteToDelete", "Attempt to delete route not originating at step used to invoke deletion.");
            }
            this.getMap().deleteRoute(theRouteId);
        }
        for (int i = 0; i < this.outGoingRoutesHandler.getElementCount(); ++i) {
            if (this.outGoingRoutes[i] != theRouteId) continue;
            this.outGoingRoutesHandler.deleteElementFromArray(this.outGoingRoutes, i);
            break;
        }
    }

    public VWRouteDefinition createRoute(int theDestinationId) throws VWException {
        VWRouteDefinition newRoute = this.getMap().createRoute(this.stepId, theDestinationId);
        this.outGoingRoutes = (Integer[])this.outGoingRoutesHandler.addElementToArray(this.outGoingRoutes, newRoute.getRouteId());
        return newRoute;
    }

    protected VWRouteDefinition createRoute(int theDestinationId, String theCondition, String theName) throws VWException {
        VWRouteDefinition newRoute = this.getMap().createRoute(this.stepId, theDestinationId, theCondition, theName);
        this.outGoingRoutes = (Integer[])this.outGoingRoutesHandler.addElementToArray(this.outGoingRoutes, newRoute.getRouteId());
        return newRoute;
    }

    protected VWRouteDefinition createRoute(int routeId, int theDestinationId, String theCondition, String theName) throws VWException {
        VWRouteDefinition newRoute = this.getMap().createRoute(routeId, this.stepId, theDestinationId, theCondition, theName);
        this.outGoingRoutes = (Integer[])this.outGoingRoutesHandler.addElementToArray(this.outGoingRoutes, newRoute.getRouteId());
        return newRoute;
    }

    public VWRouteDefinition[] getNextRoutes() throws VWException {
        int numRoutes = this.outGoingRoutesHandler.getElementCount();
        if (this.getMap() == null) {
            return null;
        }
        VWRouteDefinition[] routesStartingHere = this.getMap().getRoutesBySourceStep(this.stepId);
        if (routesStartingHere == null) {
            return null;
        }
        if (numRoutes != routesStartingHere.length) {
            throw new VWException("vw.api.VWStepDefinitionBadNextRoutes", "Inconsistent values for number of out-going routes, found {0}, recorded {1}, step id {2}.", String.valueOf(routesStartingHere.length), String.valueOf(numRoutes), String.valueOf(this.stepId));
        }
        if (numRoutes != 0) {
            VWRouteDefinition[] retRoutes = new VWRouteDefinition[numRoutes];
            for (int i = 0; i < numRoutes; ++i) {
                retRoutes[i] = this.getMap().getRoute(this.outGoingRoutes[i]);
            }
            return retRoutes;
        }
        return null;
    }

    public VWRouteDefinition getRoute(int theRouteId) throws VWException {
        return this.getMap().getRoute(theRouteId);
    }

    protected Integer[] getNextRoutesAsInteger() throws VWException {
        int numRoutes = this.outGoingRoutesHandler.getElementCount();
        VWRouteDefinition[] routesStartingHere = this.getMap().getRoutesBySourceStep(this.getStepId());
        if (routesStartingHere == null) {
            return null;
        }
        if (numRoutes != routesStartingHere.length) {
            throw new VWException("vw.api.VWStepDefinitionBadNextRoutes", "Inconsistent values for number of out-going routes, found {0}, recorded {1}, step id {3}.", String.valueOf(routesStartingHere.length), String.valueOf(numRoutes), String.valueOf(this.getStepId()));
        }
        if (numRoutes != 0) {
            return (Integer[])this.outGoingRoutesHandler.getElements(this.outGoingRoutes);
        }
        return null;
    }

    public VWRouteDefinition[] getPreviousRoutes() throws VWException {
        return this.getMap().getRoutesByDestinationStep(this.getStepId());
    }

    public VWRouteDefinition getRouteFrom(int theSourceStepId) throws VWException {
        return this.getMap().getRouteBetween(theSourceStepId, this.getStepId());
    }

    public VWRouteDefinition getRouteTo(int theDestinationStepId) throws VWException {
        return this.getMap().getRouteBetween(this.getStepId(), theDestinationStepId);
    }

    public void reorderRoutes(int[] theRouteOrder) throws VWException {
        int i;
        if (theRouteOrder == null) {
            throw new VWException("vw.api.VWStepDefinitionNullRouteOrderArray", "Parameter theRouteOrder cannot be null.");
        }
        if (theRouteOrder.length != this.outGoingRoutesHandler.getElementCount()) {
            throw new VWException("vw.api.VWStepDefinitionReorderArrayLength", "Parameter theRouteOrder actual length is {0}, expected length should be {1}.", String.valueOf(theRouteOrder.length), String.valueOf(this.outGoingRoutesHandler.getElementCount()));
        }
        if (theRouteOrder.length < 2) {
            return;
        }
        for (i = 0; i < theRouteOrder.length; ++i) {
            int j;
            for (j = 0; j < theRouteOrder.length; ++j) {
                if (j == i || theRouteOrder[i] != theRouteOrder[j]) continue;
                throw new VWException("vw.api.VWStepDefinitionReorderArrayDuplicateEntry", "Parameter theRouteOrder, route id {0} occurs more than once in the array.", String.valueOf(theRouteOrder[i]));
            }
            for (j = 0; j < theRouteOrder.length && theRouteOrder[i] != this.outGoingRoutes[j]; ++j) {
            }
            if (j != theRouteOrder.length) continue;
            throw new VWException("vw.api.VWStepDefinitionReorderArrayInvalidRoute", "Parameter theRouteOrder contains route id  {0}, which was not found in the out-going routes for this step.", String.valueOf(theRouteOrder[i]));
        }
        for (i = 0; i < theRouteOrder.length; ++i) {
            this.outGoingRoutes[i] = theRouteOrder[i];
        }
    }

    protected VWMapDefinition getMap() {
        return this.myMap;
    }

    protected void setMap(VWMapDefinition theMap) {
        this.myMap = theMap;
    }

    protected int getNextAvailableId() throws VWException {
        if (this.myMap != null) {
            return this.myMap.stepIdGenerator.getNextId();
        }
        if (this.myStepPalette != null) {
            return this.myStepPalette.getStepIdGenerator().getNextId();
        }
        throw new VWException("vw.api.VWMapNodeUnableToReturnId", "Unable to return a valid id.");
    }

    public int getNodeType() {
        if (this.stepId == 0) {
            if (this.getMap().getName().equals("Workflow")) {
                return 1;
            }
            return 2;
        }
        return 3;
    }

    public VWRuleSetDefinition[] getRuleSets(int ruleSetSelector) throws VWException {
        switch (ruleSetSelector) {
            case 0: 
            case 1: 
            case 2: {
                VWRuleSetDefinition[] retRS = null;
                if (this.ruleSets[ruleSetSelector] != null && this.ruleSets[ruleSetSelector].length > 0) {
                    retRS = new VWRuleSetDefinition[this.ruleSets[ruleSetSelector].length];
                    for (int i = 0; i < this.ruleSets[ruleSetSelector].length; ++i) {
                        retRS[i] = new VWRuleSetDefinition(null, this.ruleSets[ruleSetSelector][i]);
                    }
                }
                return retRS;
            }
        }
        throw new VWException("vw.api.VWStepDefinitionInvalidRuleSetSelector", "The parameter ruleSetSelector {0} is invalid.", String.valueOf(ruleSetSelector));
    }

    public String[] getRuleSetNames(int ruleSetSelector) throws VWException {
        switch (ruleSetSelector) {
            case 0: 
            case 1: 
            case 2: {
                return this.translateStrArray(this.ruleSets[ruleSetSelector]);
            }
        }
        throw new VWException("vw.api.VWStepDefinitionInvalidRuleSetSelector", "The parameter ruleSetSelector {0} is invalid.", String.valueOf(ruleSetSelector));
    }

    public void setRuleSets(int ruleSetSelector, VWRuleSetDefinition[] theRules) throws VWException {
        switch (ruleSetSelector) {
            case 0: 
            case 1: 
            case 2: {
                if (theRules == null || theRules.length == 0) {
                    this.ruleSets[ruleSetSelector] = null;
                    break;
                }
                String[] RSNames = new String[theRules.length];
                for (int i = 0; i < theRules.length; ++i) {
                    RSNames[i] = theRules[i].getName();
                }
                this.ruleSets[ruleSetSelector] = RSNames;
                break;
            }
            default: {
                throw new VWException("vw.api.VWMapNodeInvalidRuleSetSelector", "The parameter ruleSetSelector {0} is invalid.", String.valueOf(ruleSetSelector));
            }
        }
    }

    public void setRuleSets(int ruleSetSelector, String[] theStringRules) throws VWException {
        switch (ruleSetSelector) {
            case 0: 
            case 1: 
            case 2: {
                if (theStringRules == null || theStringRules.length == 0) {
                    this.ruleSets[ruleSetSelector] = null;
                    break;
                }
                this.ruleSets[ruleSetSelector] = theStringRules;
                break;
            }
            default: {
                throw new VWException("vw.api.VWMapNodeInvalidRuleSetSelector", "The parameter ruleSetSelector {0} is invalid.", String.valueOf(ruleSetSelector));
            }
        }
    }

    protected void deleteRuleFromRuleList(int ruleSetSelector, String theDeleteRuleSetName) throws VWException {
        switch (ruleSetSelector) {
            case 0: 
            case 1: 
            case 2: {
                if (this.ruleSets[ruleSetSelector] == null) break;
                for (int i = 0; this.ruleSets[ruleSetSelector] != null && i < this.ruleSets[ruleSetSelector].length; ++i) {
                    if (!this.ruleSets[ruleSetSelector][i].equals(theDeleteRuleSetName)) continue;
                    String[] updatedRuleNameArray = new String[this.ruleSets[ruleSetSelector].length - 1];
                    for (int j = 0; j < i; ++j) {
                        updatedRuleNameArray[j] = this.ruleSets[ruleSetSelector][j];
                    }
                    for (int k = i + 1; k < this.ruleSets[ruleSetSelector].length; ++k) {
                        updatedRuleNameArray[k - 1] = this.ruleSets[ruleSetSelector][k];
                    }
                    this.ruleSets[ruleSetSelector] = updatedRuleNameArray == null || updatedRuleNameArray.length == 0 ? null : updatedRuleNameArray;
                }
                break;
            }
            default: {
                throw new VWException("vw.api.VWMapNodeInvalidRuleSetSelector", "The parameter ruleSetSelector {0} is invalid.", String.valueOf(ruleSetSelector));
            }
        }
    }

    protected int[] getRuleSetsAsIntArray(int ruleSetSelector) throws VWException {
        throw new VWException("vw.api.VWStepDefinitionInvalidRuleSMethodCall", "The getRuleSetsAsIntArray(int) method must be reimplemented, ruleset ids on a step cannot be calculated on the client, they must be calculated on the server after flattening. You probably need to update your PE serever to match recent changes in the API to support inherited rulesets.");
    }

    protected Object clone() {
        try {
            VWMapNode clonedNode = (VWMapNode)super.clone();
            if (this.location != null) {
                clonedNode.location = new Point(this.location);
            }
            if (this.outGoingRoutes != null) {
                clonedNode.outGoingRoutes = (Integer[])this.outGoingRoutes.clone();
            }
            if (this.outGoingRoutesHandler != null) {
                clonedNode.outGoingRoutesHandler = (VWArrayHandler)this.outGoingRoutesHandler.clone();
            }
            if (this.ruleSets != null) {
                clonedNode.ruleSets = (String[][])this.ruleSets.clone();
            }
            return clonedNode;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public VWSession getSession() throws VWException {
        if (this.myMap != null && this.myMap.getWorkflow() != null) {
            return this.myMap.getWorkflow().getSession();
        }
        return null;
    }

    protected void setOriginalNodeGraphicsInfosNode(Object obj) {
        this.originalNodeGraphicsInfosNode = obj;
    }

    protected Object getOriginalNodeGraphicsInfosNode() {
        return this.originalNodeGraphicsInfosNode;
    }
}

